/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractImageBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(AbstractImageBundler.class.getName());
    public static final String CFG_FORMAT_PROPERTIES = "prop";
    public static final String CFG_FORMAT_INI = "ini";
    public static final BundlerParamInfo<String> LAUNCHER_CFG_FORMAT = new StandardBundlerParam<String>(I18N.getString("param.launcher-cfg-format.name"), I18N.getString("param.launcher-cfg-format.description"), "launcher-cfg-format", String.class, map -> "ini", (string, map) -> string);

    public void testRuntime(RelativeFileSet relativeFileSet, String[] stringArray) throws ConfigException {
        if (relativeFileSet == null) {
            return;
        }
        Pattern[] patternArray = (Pattern[])Arrays.stream(stringArray).map(Pattern::compile).toArray(Pattern[]::new);
        if (!relativeFileSet.getIncludedFiles().stream().anyMatch(string -> Arrays.stream(patternArray).anyMatch(pattern -> pattern.matcher((CharSequence)string).matches()))) {
            throw new ConfigException(MessageFormat.format(I18N.getString("error.jre-missing-file"), Arrays.toString(stringArray)), I18N.getString("error.jre-missing-file.advice"));
        }
    }

    public void imageBundleValidation(Map<String, ? super Object> map) throws ConfigException {
        StandardBundlerParam.validateMainClassInfoFromAppResources(map);
        Map map2 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        if (map2 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) continue;
                throw new ConfigException(MessageFormat.format(I18N.getString("error.empty-user-jvm-option-value"), entry.getKey()), I18N.getString("error.empty-user-jvm-option-value.advice"));
            }
        }
        if (StandardBundlerParam.MAIN_JAR.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-application-jar"), I18N.getString("error.no-application-jar.advice"));
        }
        this.extractRuntimeFlags(map);
        if (((Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(map)).booleanValue()) {
            if (((Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(map)).booleanValue()) {
                Map.Entry entry;
                if (map.containsKey("runtime") && map.get("runtime") == null) {
                    throw new ConfigException(I18N.getString("error.app-cds-requires-runtime"), I18N.getString("error.app-cds-requires-runtime.advice"));
                }
                Object object = map.get(".runtime.version.major");
                entry = map.get(".runtime.version.minor");
                if (object != null && entry != null) {
                    try {
                        int n = Integer.parseInt(object.toString());
                        int n2 = Integer.parseInt(entry.toString());
                        if (n < 8 || n == 8 && n2 < 40) {
                            throw new ConfigException(I18N.getString("error.app-cds-bad-version"), I18N.getString("error.app-cds-bad-version.advice"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                throw new ConfigException(I18N.getString("error.app-cds-no-commercial-unlock"), I18N.getString("error.app-cds-no-commercial-unlock.advice"));
            }
        }
    }

    public void writeCfgFile(Map<String, ? super Object> map, File file, String string) throws IOException {
        Map.Entry entry2;
        Object object222;
        file.delete();
        boolean bl = (Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(map) != false && (Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(map) != false;
        String string2 = (String)StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(map);
        PrintStream printStream = new PrintStream(file);
        printStream.println("[Application]");
        printStream.println("app.name=" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        printStream.println("app.classpath=" + String.join((CharSequence)File.pathSeparator, ((String)StandardBundlerParam.CLASSPATH.fetchFrom(map)).split("[ :;]")));
        printStream.println("app.runtime=" + string);
        printStream.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        if (bl) {
            printStream.println("app.appcds.cache=" + string2.split("\\+")[0]);
        }
        printStream.println();
        printStream.println("[JVMOptions]");
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        for (Object object222 : list) {
            printStream.println((String)object222);
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            printStream.println("-D" + (String)object3.getKey() + "=" + (String)object3.getValue());
        }
        object222 = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
        if (object222 != null) {
            printStream.println("-Djavafx.preloader=" + (String)object222);
        }
        printStream.println();
        printStream.println("[JVMUserOptions]");
        Map map3 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        for (Map.Entry entry2 : map3.entrySet()) {
            if (entry2.getKey() == null || entry2.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
                continue;
            }
            printStream.println(((String)entry2.getKey()).replaceAll("([\\=])", "\\\\$1") + "=" + (String)entry2.getValue());
        }
        if (bl) {
            this.prepareAppCDS(map, printStream);
        }
        printStream.println();
        printStream.println("[ArgOptions]");
        List list2 = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
        entry2 = list2.iterator();
        while (entry2.hasNext()) {
            String string3 = (String)entry2.next();
            if (string3.endsWith("=") && string3.indexOf("=") == string3.lastIndexOf("=")) {
                printStream.print(string3.substring(0, string3.length() - 1));
                printStream.println("\\=");
                continue;
            }
            printStream.println(string3);
        }
        printStream.close();
    }

    protected abstract String getCacheLocation(Map<String, ? super Object> var1);

    void prepareAppCDS(Map<String, ? super Object> map, PrintStream printStream) throws IOException {
        File file = Files.createTempDirectory("javapackager", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        File file2 = new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".classlist");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);
             PrintStream printStream2 = new PrintStream(fileOutputStream);){
            for (String string : (List)StandardBundlerParam.APP_CDS_CLASS_ROOTS.fetchFrom(map)) {
                String string2 = string.replace(".", "/");
                printStream2.println(string2);
            }
        }
        ((List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map)).add(new RelativeFileSet(file2.getParentFile(), Arrays.asList(file2)));
        printStream.println();
        printStream.println("[AppCDSJVMOptions]");
        printStream.println("-XX:+UnlockCommercialFeatures");
        printStream.print("-XX:SharedArchiveFile=");
        printStream.print(this.getCacheLocation(map));
        printStream.print((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        printStream.println(".jpa");
        printStream.println("-Xshare:auto");
        printStream.println("-XX:+UseAppCDS");
        if (Log.isDebug()) {
            printStream.println("-verbose:class");
            printStream.println("-XX:+TraceClassPaths");
            printStream.println("-XX:+UnlockDiagnosticVMOptions");
        }
        printStream.println("");
        printStream.println("[AppCDSGenerateCacheJVMOptions]");
        printStream.println("-XX:+UnlockCommercialFeatures");
        printStream.println("-Xshare:dump");
        printStream.println("-XX:+UseAppCDS");
        printStream.print("-XX:SharedArchiveFile=");
        printStream.print(this.getCacheLocation(map));
        printStream.print((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        printStream.println(".jpa");
        printStream.println("-XX:SharedClassListFile=$PACKAGEDIR/" + (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".classlist");
        if (Log.isDebug()) {
            printStream.println("-XX:+UnlockDiagnosticVMOptions");
        }
    }

    public abstract void extractRuntimeFlags(Map<String, ? super Object> var1);

    public static void extractFlagsFromVersion(Map<String, ? super Object> map, String string) {
        Pattern pattern = Pattern.compile("(\\d*)[- ]?[bB]it");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            map.put(".runtime.bit-arch", matcher.group(1));
        } else {
            map.put(".runtime.bit-arch", "32");
        }
        Pattern pattern2 = Pattern.compile("java version \"((\\d+.(\\d+).\\d+)(_(\\d+)))?(-(.*))?\"");
        matcher = pattern2.matcher(string);
        if (matcher.find()) {
            map.put(".runtime.version", matcher.group(1));
            map.put(".runtime.version.release", matcher.group(2));
            map.put(".runtime.version.major", matcher.group(3));
            map.put(".runtime.version.update", matcher.group(5));
            map.put(".runtime.version.minor", matcher.group(5));
            map.put(".runtime.version.security", matcher.group(5));
            map.put(".runtime.version.patch", "0");
            map.put(".runtime.version.modifiers", matcher.group(7));
        } else {
            Pattern pattern3 = Pattern.compile("java version \"((\\d+).(\\d+).(\\d+).(\\d+))(-(.*))?(\\+[^\"]*)?\"");
            matcher = pattern3.matcher(string);
            if (matcher.find()) {
                map.put(".runtime.version", matcher.group(1));
                map.put(".runtime.version.release", matcher.group(1));
                map.put(".runtime.version.major", matcher.group(2));
                map.put(".runtime.version.update", matcher.group(3));
                map.put(".runtime.version.minor", matcher.group(3));
                map.put(".runtime.version.security", matcher.group(4));
                map.put(".runtime.version.patch", matcher.group(5));
                map.put(".runtime.version.modifiers", matcher.group(7));
            } else {
                map.put(".runtime.version", "");
                map.put(".runtime.version.release", "");
                map.put(".runtime.version.major", "");
                map.put(".runtime.version.update", "");
                map.put(".runtime.version.minor", "");
                map.put(".runtime.version.security", "");
                map.put(".runtime.version.patch", "");
                map.put(".runtime.version.modifiers", "");
            }
        }
    }
}

