/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class ClassDumpInstance
implements Instance {
    ClassDump classDump;

    ClassDumpInstance(ClassDump classDump) {
        this.classDump = classDump;
    }

    @Override
    public List getFieldValues() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isGCRoot() {
        return this.classDump.getHprof().getGCRoot(this) != null;
    }

    @Override
    public long getInstanceId() {
        return this.classDump.getJavaClassId();
    }

    @Override
    public int getInstanceNumber() {
        return this.classDump.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    @Override
    public JavaClass getJavaClass() {
        return this.classDump.classDumpSegment.java_lang_Class;
    }

    @Override
    public Instance getNearestGCRootPointer() {
        return this.classDump.getHprof().getNearestGCRootPointer(this);
    }

    @Override
    public int getReachableSize() {
        return 0;
    }

    @Override
    public List getReferences() {
        return this.classDump.getReferences();
    }

    @Override
    public int getRetainedSize() {
        return this.classDump.getHprof().getRetainedSize(this);
    }

    @Override
    public int getSize() {
        return this.getJavaClass().getInstanceSize();
    }

    @Override
    public List getStaticFieldValues() {
        return this.getJavaClass().getStaticFieldValues();
    }

    @Override
    public Object getValueOfField(String string) {
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ClassDumpInstance) {
            return this.classDump.equals(((ClassDumpInstance)object).classDump);
        }
        return false;
    }

    public int hashCode() {
        return this.classDump.hashCode();
    }
}

