/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.GlobalTraceBuffer;
import oracle.jvm.hotspot.jfr.JFRDebug;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.ThreadLocalTraceBuffer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class JFRBuffers
extends VMObject {
    private static AddressField globalTraceBufferFullListField;
    private static GlobalTraceBuffer globalTraceBufferFullList;
    private static AddressField globalTraceBufferFreeListField;
    private static GlobalTraceBuffer globalTraceBufferFreeList;
    private static AddressField threadLocalTraceBufferListField;
    private static ThreadLocalTraceBuffer threadLocalTraceBufferList;
    private static Field globalTraceBuffersTotalSizeField;
    private static int globalTraceBuffersTotalSize;
    private static Field globalTraceBuffersElemCountField;
    private static int globalTraceBuffersElemCount;
    private static Field threadLocalTraceBuffersTotalSizeField;
    private static int threadLocalTraceBuffersTotalSize;
    private static Field threadLocalTraceBuffersElemCountField;
    private static int threadLocalTraceBuffersElemCount;

    public JFRBuffers(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrBuffers");
        globalTraceBufferFullListField = type.getAddressField("_global_trace_buffer_full_list");
        globalTraceBufferFreeListField = type.getAddressField("_global_trace_buffer_free_list");
        globalTraceBuffersTotalSizeField = type.getField("_global_trace_buffers_total_size");
        globalTraceBuffersElemCountField = type.getField("_global_trace_buffers_elem_count");
        threadLocalTraceBuffersTotalSizeField = type.getField("_thread_local_trace_buffers_total_size");
        threadLocalTraceBuffersElemCountField = type.getField("_thread_local_trace_buffers_elem_count");
        threadLocalTraceBufferListField = type.getAddressField("_thread_local_trace_buffer_list");
    }

    public GlobalTraceBuffer globalTraceBufferFullList() {
        globalTraceBuffersTotalSize = globalTraceBuffersTotalSizeField.getJInt(this.addr);
        globalTraceBuffersElemCount = globalTraceBuffersElemCountField.getJInt(this.addr);
        threadLocalTraceBuffersTotalSize = threadLocalTraceBuffersTotalSizeField.getJInt(this.addr);
        threadLocalTraceBuffersElemCount = threadLocalTraceBuffersElemCountField.getJInt(this.addr);
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("GlobalTraceBuffer.globalTraceBufferFullList(): global trace buffer full list address = " + globalTraceBufferFullListField.getValue(this.addr));
        }
        globalTraceBufferFullList = (GlobalTraceBuffer)VMObjectFactory.newObject(GlobalTraceBuffer.class, globalTraceBufferFullListField.getValue(this.addr));
        return globalTraceBufferFullList;
    }

    public GlobalTraceBuffer globalTraceBufferFreeList() {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("GlobalTraceBuffer.globalTraceBufferFreeList(): global trace buffer free list address = " + globalTraceBufferFreeListField.getValue(this.addr));
        }
        globalTraceBufferFreeList = (GlobalTraceBuffer)VMObjectFactory.newObject(GlobalTraceBuffer.class, globalTraceBufferFreeListField.getValue(this.addr));
        return globalTraceBufferFreeList;
    }

    public ThreadLocalTraceBuffer threadLocalTraceBufferList() {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("ThreadLocalTraceBuffer.threadLocalTraceBufferList(): thread local trace buffer list address = " + threadLocalTraceBufferListField.getValue(this.addr));
        }
        threadLocalTraceBufferList = (ThreadLocalTraceBuffer)VMObjectFactory.newObject(ThreadLocalTraceBuffer.class, threadLocalTraceBufferListField.getValue(this.addr));
        return threadLocalTraceBufferList;
    }

    public int write_all_buffers(JFRStreamWriter writer) {
        int accumulated_size = 0;
        accumulated_size += this.write_all_global_buffers(writer);
        return accumulated_size += this.write_all_thread_local_buffers(writer);
    }

    public int write_all_global_buffers(JFRStreamWriter writer) {
        int accumulated_size = 0;
        for (GlobalTraceBuffer free_buffer = this.globalTraceBufferFreeList(); free_buffer != null; free_buffer = free_buffer.getNextGlobalTraceBuffer()) {
            free_buffer.write(writer);
        }
        accumulated_size = this.write_all_full_global_buffers(writer);
        return accumulated_size;
    }

    public int write_all_full_global_buffers(JFRStreamWriter writer) {
        int accumulated_size = 0;
        for (GlobalTraceBuffer full_buffer = this.globalTraceBufferFullList(); full_buffer != null; full_buffer = full_buffer.getNextGlobalTraceBuffer()) {
            full_buffer.write(writer);
        }
        return accumulated_size;
    }

    public int write_all_thread_local_buffers(JFRStreamWriter writer) {
        int accumulated_size = 0;
        for (ThreadLocalTraceBuffer thread_local_buffer = this.threadLocalTraceBufferList(); thread_local_buffer != null; thread_local_buffer = thread_local_buffer.getNextThreadLocalTraceBuffer()) {
            thread_local_buffer.write(writer);
        }
        return accumulated_size;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRBuffers.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

